//
//  BIAllClientsSummary.h
//  BISubstrate
//
//  Created by Fraser Kuyvenhoven on 21/08/08.
//  Copyright 2008 Marketcircle. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class BIDatabaseObjectContext;


@interface BIAllClientsSummary : NSObject
{
	BIDatabaseObjectContext* _context;
	
	NSNumber *balance;
	NSNumber *retainersBalance;
	NSNumber *unbilledAmount;
	NSNumber *incompleteAmount;
	NSNumber *overdueAmount;
	
	BOOL balanceRequested;
	BOOL retainersBalanceRequested;
	BOOL unbilledAmountRequested;
	BOOL incompleteAmountRequested;
	BOOL overdueAmountRequested;
	
	BOOL balanceInvalid;
	BOOL retainersBalanceInvalid;
	BOOL unbilledAmountInvalid;
	BOOL incompleteAmountInvalid;
	BOOL overdueAmountInvalid;
}

- (void)invalidateAllValues;

- (BIDatabaseObjectContext*)objectContext;
- (void)setObjectContext:(BIDatabaseObjectContext*)context;

- (NSNumber *)balance;
- (void)setBalance:(NSNumber *)aBalance;
- (NSNumber *)retainersBalance;
- (void)setRetainersBalance:(NSNumber *)aRetainersBalance;
- (NSNumber *)unbilledAmount;
- (void)setUnbilledAmount:(NSNumber *)anUnbilledAmount;
- (NSNumber *)incompleteAmount;
- (void)setIncompleteAmount:(NSNumber *)anIncompleteAmount;
- (NSNumber *)overdueAmount;
- (void)setOverdueAmount:(NSNumber *)anOverdueAmount;

@end
